/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.device.EventType;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Client;
import com.tp_link.eap.domain.eap.ClientHistory;
import com.tp_link.eap.domain.eap.StatLifeClient;
import com.tp_link.eap.domain.eap.bean.ClientRateLimitSetting;
import com.tp_link.eap.domain.eapsetting.ClientControl;
import com.tp_link.eap.domain.eapsetting.ClientRateConfig;
import com.tp_link.eap.domain.eapsetting.ClientRateLimit;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.portal.Guest;
import com.tp_link.eap.domain.record.SettingRecord;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.a.a;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.monitor.cache.CacheTask;
import com.tp_link.eap.monitor.monitor.cache.ClientConnection;
import com.tp_link.eap.monitor.monitor.model.ClientModel;
import com.tp_link.eap.monitor.monitor.realtime.RealtimeStatus;
import com.tp_link.eap.monitor.monitor.repo.ClientHistoryRepository;
import com.tp_link.eap.monitor.monitor.repo.ClientRepository;
import com.tp_link.eap.monitor.monitor.repo.StatLifeClientRepository;
import com.tp_link.eap.monitor.monitor.service.b;
import com.tp_link.eap.monitor.monitor.service.c;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.j;
import com.tp_link.eap.monitor.portal.repo.GuestRepository;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="clientService")
public class ClientService
extends com.tp_link.eap.i.a.a<Client>
implements d {
    @Autowired
    private ClientRepository a;
    @Autowired
    private StatLifeClientRepository b;
    @Autowired
    private ClientHistoryRepository c;
    @Autowired
    private GuestRepository d;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a e;
    @Autowired
    private j f;
    @Autowired
    private b g;
    @Autowired
    private c h;
    @Autowired
    private com.tp_link.eap.monitor.record.service.b i;
    @Autowired
    private com.tp_link.eap.monitor.portal.service.a j;
    @Autowired
    private g k;
    private Logger l = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<Client> getClients() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
    }

    @Override
    public List<Client> getAllBlockClients() {
        return this.a.findByIsBlock(true);
    }

    @Override
    public List<Client> getSiteBlockClients(String site) {
        return this.a.findByIsBlockAndSite(true, site);
    }

    @Override
    public Client getClient(String clientId) {
        if (clientId == null) {
            return null;
        }
        return (Client)this.a.findOne((Serializable)((Object)clientId));
    }

    @Override
    public OperationResponse getClientRateLimit(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("clientMac");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Client client = this.getClient(string, com.tp_link.eap.d.b.a());
        ClientRateLimitSetting clientRateLimitSetting = null;
        clientRateLimitSetting = client != null && client.getClientRateLimitSetting() != null ? client.getClientRateLimitSetting() : new ClientRateLimitSetting();
        return new OperationResponse(ResErrorCode.a, (Object)clientRateLimitSetting);
    }

    @Override
    public Client getClient(String mac, String site) {
        if (mac == null) {
            return null;
        }
        return this.a.findByMacAndSite(mac, site);
    }

    public List<Client> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<Client> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<Client> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public List<Client> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.countByFilters(filters, searchFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse block(String clientMac) {
        Object object;
        if (clientMac == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Client client = this.getClient(clientMac, com.tp_link.eap.d.b.a());
        if (client == null) {
            return new OperationResponse(ResErrorCode.cN);
        }
        QueryFilter queryFilter = new QueryFilter("isBlock", (Object)true, QueryFilter.FilterType.eq);
        long l2 = this.count(Collections.singletonList(queryFilter), null);
        if (l2 >= 500L) {
            return new OperationResponse(ResErrorCode.cO);
        }
        Object object2 = object = com.tp_link.eap.b.b.a.b((String)clientMac);
        synchronized (object2) {
            client.setBlock(true);
            this.a.save(client);
        }
        object2 = new ClientControl();
        object2.setClientMac(clientMac);
        object2.setOperation(Integer.valueOf(0));
        this.sendClientOperation((ClientControl)object2, null);
        this.f.refreshLifeClientStatByClientMac(clientMac, com.tp_link.eap.d.b.a());
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse clientBlock(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("clientMac");
        return this.block(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse unblock(String clientMac) {
        Object object;
        if (clientMac == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Client client = this.getClient(clientMac, com.tp_link.eap.d.b.a());
        if (client == null) {
            return new OperationResponse(ResErrorCode.cP);
        }
        Object object2 = object = com.tp_link.eap.b.b.a.b((String)clientMac);
        synchronized (object2) {
            client.setBlock(false);
            this.a.save(client);
        }
        object2 = new ClientControl();
        object2.setClientMac(clientMac);
        object2.setOperation(Integer.valueOf(1));
        this.sendClientOperation((ClientControl)object2, null);
        this.f.refreshLifeClientStatByClientMac(clientMac, com.tp_link.eap.d.b.a());
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse clientUnblock(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("clientMac");
        return this.unblock(string);
    }

    @Override
    public OperationResponse reconnect(String clientMac) {
        if (clientMac == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Client client = this.getClient(clientMac, com.tp_link.eap.d.b.a());
        if (client == null) {
            return new OperationResponse(ResErrorCode.cM);
        }
        ClientControl clientControl = new ClientControl();
        clientControl.setClientMac(clientMac);
        clientControl.setOperation(Integer.valueOf(2));
        this.sendClientOperation(clientControl, client.getApMac());
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResult reconnect(String clientMac, String apMac) {
        if (com.tp_link.eap.util.a.e.a((String)clientMac) || com.tp_link.eap.util.a.e.a((String)apMac)) {
            this.l.warn("Invalid params: clientMac or apMac is null");
            return com.tp_link.eap.util.e.aX;
        }
        ClientControl clientControl = new ClientControl();
        clientControl.setClientMac(clientMac);
        clientControl.setOperation(Integer.valueOf(2));
        this.sendClientOperation(clientControl, apMac);
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public OperationResponse clientReconnect(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("clientMac");
        return this.reconnect(string);
    }

    @Override
    public OperationResponse unauthorize(String clientId) {
        if (com.tp_link.eap.util.a.e.a((String)clientId)) {
            return com.tp_link.eap.util.e.aZ;
        }
        return this.j.unAuth(clientId);
    }

    @Override
    public OperationResponse unauthorize(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("clientId");
        return this.unauthorize(string);
    }

    @Override
    public boolean disconnectClient(String apMac) {
        this.l.debug("disconnect clients for mac : " + apMac);
        List<Client> list = this.a.findByApMacAndIsActive(apMac, true);
        if (!CollectionUtils.isEmpty(list)) {
            this.a(list);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(List<Client> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (Client client : list) {
                Object object;
                Object object2 = object = com.tp_link.eap.b.b.a.b((String)client.getMac());
                synchronized (object2) {
                    CacheTask.a.b(client.getMac());
                    this.l.debug("disconnected for mac : " + client.getMac());
                    Client client2 = this.getClient(client.getMac(), client.getSite());
                    if (client2 != null) {
                        client2.setActive(false);
                        this.a.save(client2);
                    }
                    this.f.deleteCurrentClientStat(client.getMac());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshClients(ConcurrentHashMap<String, Client> clientMap, List<String> apMacs, ConcurrentHashMap<String, com.tp_link.eap.monitor.monitor.cache.b> cacheApMap, ClientConnection clientConnection) {
        Object object;
        Object object2;
        Object object3;
        List<Client> list = this.a.findByIsActive(true);
        ArrayList<Client> arrayList = new ArrayList<Client>(clientMap.values());
        if (this.l.isDebugEnabled()) {
            this.l.debug("oldActiveClients size {}, currentActiveClients size {}", (Object)list.size(), (Object)arrayList.size());
        }
        if (!CollectionUtils.isEmpty(list)) {
            block15: for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object4;
                Object object5;
                Client client = list.get(i2);
                object3 = clientMap.get(client.getMac());
                if (object3 == null) {
                    this.l.trace("Old online client {} is not inform this time, may be offline", (Object)client.getMac());
                    continue;
                }
                object2 = cacheApMap.get(object3.getApMac());
                if (object2 == null || ((com.tp_link.eap.monitor.monitor.cache.b)object2).e() > object3.getLastSeen()) {
                    this.l.debug("client {} is no longer connected to {}", (Object)object3.getMac(), (Object)object3.getApMac());
                    clientMap.remove(object3.getMac());
                    if (CollectionUtils.isEmpty(arrayList)) continue;
                    for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                        if (!((Client)arrayList.get(i3)).getMac().equals(object3.getMac())) continue;
                        arrayList.remove(i3);
                        continue block15;
                    }
                    continue;
                }
                String string = object3.getMac();
                this.l.debug("Cache Client Mac: {}", (Object)string);
                object = com.tp_link.eap.b.b.a.b((String)string);
                if (!client.getSite().equals(object3.getSite())) {
                    this.l.debug("site of client {} changed from {} to {}", new Object[]{client.getName(), client.getSite(), object3.getSite()});
                    object5 = object;
                    synchronized (object5) {
                        object4 = (Client)this.a.findOne((Serializable)((Object)client.getId()));
                        if (object4 != null) {
                            object4.setActive(false);
                            this.a.save(object4);
                            this.f.deleteCurrentClientStat(client.getMac());
                        }
                    }
                    list.remove(i2);
                    --i2;
                    continue;
                }
                clientConnection.a((Client)object3);
                object5 = this.f.getScc(client.getMac());
                if (object5 != null && object5.getDownload() + object5.getUpload() > object3.getDownload() + object3.getUpload() && object5.getDuration() > object3.getDuration()) {
                    object4 = object;
                    synchronized (object4) {
                        this.f.deleteCurrentClientStat(client.getMac());
                    }
                }
                object4 = object;
                synchronized (object4) {
                    this.l.debug("refreshClients clientMac: {}, site: {}", (Object)string, (Object)object3.getSite());
                    Client client2 = (Client)this.a.findOne((Serializable)((Object)client.getId()));
                    this.a(client2, (Client)object3);
                }
                list.remove(i2);
                if (!CollectionUtils.isEmpty(arrayList)) {
                    for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                        if (!((Client)arrayList.get(i4)).getMac().equals(client.getMac())) continue;
                        arrayList.remove(i4);
                        break;
                    }
                }
                --i2;
            }
            if (!list.isEmpty()) {
                for (Client client : list) {
                    if (!apMacs.contains(client.getApMac())) {
                        this.l.debug("ap {} is not in cache", (Object)client.getApMac());
                        object3 = this.g.getApByMac(client.getApMac());
                        if (object3 != null && object3.getStatus() == 1 && object3.getSite().equals(client.getSite())) {
                            this.l.debug("ap {} is connected, no need to handle it's client {}", (Object)client.getApMac(), (Object)client.getName());
                            continue;
                        }
                    }
                    object3 = client.getMac();
                    Object object6 = object2 = com.tp_link.eap.b.b.a.b((String)object3);
                    synchronized (object6) {
                        client = (Client)this.a.findOne((Serializable)((Object)client.getId()));
                        if (client != null && client.isActive()) {
                            client.setActive(false);
                            this.a.save(client);
                            this.f.deleteCurrentClientStat(client.getMac());
                        }
                    }
                }
            }
        }
        if (!arrayList.isEmpty()) {
            for (Client client : arrayList) {
                object3 = cacheApMap.get(client.getApMac());
                if (object3 == null || ((com.tp_link.eap.monitor.monitor.cache.b)object3).e() > client.getLastSeen()) {
                    this.l.debug("client {} is no longer connected to {}", (Object)client.getMac(), (Object)client.getApMac());
                    if (object3 == null) continue;
                    clientMap.remove(client.getMac());
                    continue;
                }
                clientConnection.a(client);
                Object object7 = object2 = com.tp_link.eap.b.b.a.b((String)client.getMac());
                synchronized (object7) {
                    object = this.a.findByMacAndSite(client.getMac(), client.getSite());
                    this.a((Client)object, client);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeConnectedApName(String apMac, String newName) {
        if (apMac == null || newName == null) {
            return false;
        }
        List<Client> list = this.a.findByApMacAndIsActive(apMac, true);
        if (!CollectionUtils.isEmpty(list)) {
            for (Client client : list) {
                Object object;
                Object object2 = object = com.tp_link.eap.b.b.a.b((String)client.getMac());
                synchronized (object2) {
                    client.setApName(newName);
                    this.a.save(client);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendClientOperation(ClientControl cc, String singleMac) {
        Client client;
        Object object;
        List<Ap> list = null;
        list = singleMac == null ? this.g.getSiteAdoptedAps(com.tp_link.eap.d.b.a()) : Collections.singletonList(this.g.getApDetail(singleMac));
        if (cc.getOperation() == 0) {
            Object object2;
            String string = cc.getClientMac();
            object = object2 = com.tp_link.eap.b.b.a.b((String)string);
            synchronized (object) {
                client = CacheTask.a.b().remove(string);
                if (client != null) {
                    this.f.refreshCurrentClientStat(client);
                }
                if ((client = this.getClient(string, com.tp_link.eap.d.b.a())) != null && client.isActive()) {
                    this.a(Collections.singletonList(this.getClient(cc.getClientMac(), com.tp_link.eap.d.b.a())));
                }
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                object = ap.getMac();
                if (com.tp_link.eap.monitor.monitor.realtime.c.c(ap.getMac()) && ap.getStatus() == 1) {
                    Object object2;
                    client = new EapConfigBody();
                    client.setClientOperation(Collections.singletonList(cc));
                    client.setSequenceId(Integer.valueOf(65532));
                    client.setConfigVersion(this.i.getSettingVersion((String)object).getBase());
                    this.l.debug("client operation : " + client);
                    Object object3 = object2 = com.tp_link.eap.b.b.a.a((String)object);
                    synchronized (object3) {
                        com.tp_link.eap.monitor.monitor.realtime.c.a((String)object, RealtimeStatus.d);
                        this.g.setApRealtimeStatus((String)object, RealtimeStatus.d);
                        if (cc.getOperation() == 0 || cc.getOperation() == 1) {
                            this.i.refreshVersion((String)object);
                            client.setSequenceId(Integer.valueOf(65531));
                        }
                        if (cc.getOperation() == 3) {
                            this.i.refreshVersion((String)object);
                            client.setSequenceId(Integer.valueOf(65530));
                            com.tp_link.eap.monitor.portal.a.a.a(cc, (String)object);
                        }
                    }
                    com.tp_link.eap.monitor.a.a.a(EventType.EVENT_SETTING, EapConfigBody.class, client, (String)object);
                    continue;
                }
                this.a((String)object, cc);
            }
        }
    }

    @Override
    public void deleteBySite() {
        List<StatLifeClient> list;
        String string = com.tp_link.eap.d.b.a();
        List<Client> list2 = this.a.findBySite(string);
        if (!CollectionUtils.isEmpty(list2)) {
            this.a.delete(list2);
        }
        if (!CollectionUtils.isEmpty(list = this.b.findBySite(string))) {
            this.b.delete(list);
        }
    }

    @Override
    public long countApActiveClients(String apMac, int radioId) {
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("apMac", (Object)apMac, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("radioId", (Object)radioId, QueryFilter.FilterType.eq));
        return this.count(arrayList, null);
    }

    @Override
    public long countSsidActiveClients(String ssid) {
        ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
        arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
        arrayList.add(new QueryFilter("ssid", (Object)ssid, QueryFilter.FilterType.eq));
        return this.count(arrayList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, ClientControl clientControl) {
        Object object;
        if (clientControl == null || string == null) {
            this.l.warn("clientConfig to set is null");
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            SettingRecord settingRecord = this.e.getRecord(string, SettingRecord.SettingStatus.PENDING);
            if (settingRecord == null) {
                settingRecord = this.e.getRecord(string, SettingRecord.SettingStatus.BACKUP);
            }
            EapConfigBody eapConfigBody = new EapConfigBody();
            if (settingRecord == null) {
                eapConfigBody.setClientOperation(Collections.singletonList(clientControl));
                SettingRecord settingRecord2 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                this.e.refreshRecord(settingRecord2);
            } else {
                eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord.getContent(), EapConfigBody.class);
                if (eapConfigBody == null) {
                    eapConfigBody = new EapConfigBody();
                    eapConfigBody.setClientOperation(Collections.singletonList(clientControl));
                    SettingRecord settingRecord3 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                    this.e.refreshRecord(settingRecord3);
                } else if (CollectionUtils.isEmpty((Collection)eapConfigBody.getClientOperation())) {
                    eapConfigBody.setClientOperation(Collections.singletonList(clientControl));
                    settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                    this.e.refreshRecord(settingRecord);
                } else {
                    this.a(eapConfigBody.getClientOperation(), clientControl);
                    if (CollectionUtils.isEmpty((Collection)eapConfigBody.getClientOperation())) {
                        eapConfigBody.setClientOperation(null);
                    }
                    settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                    this.e.refreshRecord(settingRecord);
                }
            }
        }
    }

    private void a(List<ClientControl> list, ClientControl clientControl) {
        boolean bl = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ClientControl clientControl2 = list.get(i2);
            if (!clientControl2.getClientMac().equals(clientControl.getClientMac())) continue;
            if (clientControl.getOperation().equals(3)) {
                if (!clientControl2.getOperation().equals(3)) continue;
                bl = true;
                break;
            }
            bl = true;
            if (clientControl.getOperation() == 2) break;
            if (clientControl2.getOperation() == 2) {
                list.set(i2, clientControl);
                break;
            }
            list.remove(i2);
            break;
        }
        if (!bl) {
            list.add(clientControl);
        }
    }

    @Override
    public Integer getClientRateLimitCount(String site) {
        List<Client> list = this.getRateLimitClientsBySite(site);
        return list.size();
    }

    @Override
    public List<Client> getRateLimitClientsBySite(String site) {
        List<Client> list = this.a.findBySite(site);
        ArrayList<Client> arrayList = new ArrayList<Client>();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Client client = list.get(i2);
                if (client.getClientRateLimitSetting() == null || client.getClientRateLimitSetting().getDownloadRateLimit() <= 0L && client.getClientRateLimitSetting().getUploadRateLimit() <= 0L) continue;
                arrayList.add(client);
            }
        }
        return arrayList;
    }

    @Override
    public List<Client> getRateLimitClients() {
        List<Client> list = this.getClients();
        ArrayList<Client> arrayList = new ArrayList<Client>();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Client client = list.get(i2);
                if (client.getClientRateLimitSetting() == null || client.getClientRateLimitSetting().getDownloadRateLimit() <= 0L && client.getClientRateLimitSetting().getUploadRateLimit() <= 0L) continue;
                arrayList.add(client);
            }
        }
        return arrayList;
    }

    @Override
    public void refreshClient(Client client) {
        if (client != null) {
            this.a();
            this.a.save(client);
        }
    }

    @Override
    public OperationResult sendRateLimit(String clientMac, String site, ClientRateLimitSetting setting) {
        List<Ap> list = this.g.getSiteAdoptedAps(site);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                String string = ap.getMac();
                ClientRateLimit clientRateLimit = this.k.a(clientMac, site, setting);
                this.refreshRateLimitRecordByAp(string, clientRateLimit);
            }
        }
        return com.tp_link.eap.util.e.bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRateLimitRecordByAp(String apMac, ClientRateLimit srl) {
        Object object;
        if (srl == null || apMac == null) {
            this.l.warn("clientConfig to set is null");
        }
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)apMac);
        synchronized (object2) {
            SettingRecord settingRecord = this.e.getRecord(apMac, SettingRecord.SettingStatus.PENDING);
            if (settingRecord == null) {
                settingRecord = this.e.getRecord(apMac, SettingRecord.SettingStatus.BACKUP);
            }
            EapConfigBody eapConfigBody = new EapConfigBody();
            if (settingRecord == null) {
                eapConfigBody.setClientRateConfig(this.b(Collections.singletonList(srl)));
                SettingRecord settingRecord2 = new SettingRecord(apMac, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                this.e.refreshRecord(settingRecord2);
            } else {
                eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord.getContent(), EapConfigBody.class);
                if (eapConfigBody == null) {
                    eapConfigBody = new EapConfigBody();
                    eapConfigBody.setClientRateConfig(this.b(Collections.singletonList(srl)));
                    SettingRecord settingRecord3 = new SettingRecord(apMac, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                    this.e.refreshRecord(settingRecord3);
                } else {
                    ClientRateConfig clientRateConfig = eapConfigBody.getClientRateConfig();
                    ArrayList<ClientRateLimit> arrayList = new ArrayList();
                    if (clientRateConfig != null) {
                        arrayList = clientRateConfig.getClientRateLimit();
                    }
                    if (CollectionUtils.isEmpty(arrayList)) {
                        eapConfigBody.setClientRateConfig(this.b(Collections.singletonList(srl)));
                        settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                        this.e.refreshRecord(settingRecord);
                    } else {
                        List<ClientRateLimit> list = this.a(arrayList, srl);
                        eapConfigBody.setClientRateConfig(this.b(list));
                        settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                        this.e.refreshRecord(settingRecord);
                    }
                }
            }
        }
    }

    @Override
    public OperationResponse getGridActiveClients(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        grid.initFilters("isActive", (Object)true, QueryFilter.FilterType.eq);
        String string = (String)queryData.getFilters().get("type");
        if (!com.tp_link.eap.util.a.e.a((String)string)) {
            if (string.equalsIgnoreCase("guest")) {
                grid.initFilters("isGuest", (Object)true, QueryFilter.FilterType.eq);
            } else if (string.equalsIgnoreCase("user")) {
                grid.initFilters("isGuest", (Object)false, QueryFilter.FilterType.eq);
            } else if (!string.equalsIgnoreCase("all")) {
                return new OperationResponse(ResErrorCode.d);
            }
        } else {
            return new OperationResponse(ResErrorCode.d);
        }
        String string2 = (String)queryData.getFilters().get("apMac");
        if (string2 != null) {
            grid.initFilters("apMac", (Object)string2, QueryFilter.FilterType.eq);
            grid.initSearch(queryData.getSearchKey(), new String[]{"mac", "ssid"});
        } else {
            grid.initSearch(queryData.getSearchKey(), new String[]{"mac", "apName", "ssid", "name", "ip"});
        }
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        ArrayList<ClientModel> arrayList = new ArrayList<ClientModel>();
        for (Client client : list) {
            ClientModel clientModel = ClientModel.convertFromClient(client);
            arrayList.add(clientModel);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse saveClientRateLimit(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        long l2 = jSONObject.optLong("downloadRateLimit");
        long l3 = jSONObject.optLong("uploadRateLimit");
        String string = jSONObject.optString("clientMac");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        boolean bl = false;
        Client client = this.getClient(string, com.tp_link.eap.d.b.a());
        if (client == null) {
            return new OperationResponse(ResErrorCode.cW);
        }
        ClientRateLimitSetting clientRateLimitSetting = client.getClientRateLimitSetting();
        if (clientRateLimitSetting != null) {
            if (clientRateLimitSetting.getDownloadRateLimit() == l2 && clientRateLimitSetting.getUploadRateLimit() == l3) {
                return new OperationResponse(ResErrorCode.a, "No change", null);
            }
            bl = true;
        } else if (l2 == 0L && l3 == 0L) {
            bl = false;
        } else if (this.getClientRateLimitCount(com.tp_link.eap.d.b.a()) < 3000) {
            bl = true;
        } else {
            return new OperationResponse(ResErrorCode.cX);
        }
        clientRateLimitSetting = new ClientRateLimitSetting();
        clientRateLimitSetting.setDownloadRateLimit(Long.valueOf(l2));
        clientRateLimitSetting.setUploadRateLimit(Long.valueOf(l3));
        client.setClientRateLimitSetting(clientRateLimitSetting);
        Object object2 = object = com.tp_link.eap.b.b.a.b((String)string);
        synchronized (object2) {
            this.refreshClient(client);
            this.f.refreshRateLimit(client);
        }
        if (bl) {
            this.sendRateLimit(string, com.tp_link.eap.d.b.a(), clientRateLimitSetting);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getApClientList(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"apMac") || jSONObject.get("apMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("apMac");
        List<Client> list = this.a.findByApMacAndIsActive(string, true);
        if (list != null && list.isEmpty()) {
            list = null;
        }
        ArrayList<ClientModel> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<ClientModel>();
            for (Client client : list) {
                ClientModel clientModel = ClientModel.convertFromClient(client);
                arrayList.add(clientModel);
            }
        }
        HashMap<String, ArrayList<ClientModel>> hashMap = new HashMap<String, ArrayList<ClientModel>>();
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)hashMap);
    }

    @Override
    public OperationResponse getClientInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.containsKey((Object)"clientMac") || jSONObject.get("clientMac") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.getString("clientMac");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Client client = this.getClient(string, com.tp_link.eap.d.b.a());
        ClientModel clientModel = ClientModel.convertFromClient(client);
        return new OperationResponse(ResErrorCode.a, (Object)clientModel);
    }

    @Override
    public void deleteAll() {
        this.a.deleteAll();
        this.b.deleteAll();
    }

    private List<ClientRateLimit> a(List<ClientRateLimit> list, ClientRateLimit clientRateLimit) {
        boolean bl = false;
        ArrayList<ClientRateLimit> arrayList = new ArrayList<ClientRateLimit>(list);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ClientRateLimit clientRateLimit2 = (ClientRateLimit)arrayList.get(i2);
            if (!clientRateLimit2.getMac().equals(clientRateLimit.getMac())) continue;
            bl = true;
            clientRateLimit2.setDown(clientRateLimit.getDown());
            clientRateLimit2.setUp(clientRateLimit.getUp());
            break;
        }
        if (!bl) {
            arrayList.add(clientRateLimit);
        }
        return arrayList;
    }

    private ClientRateConfig b(List<ClientRateLimit> list) {
        ClientRateConfig clientRateConfig = new ClientRateConfig();
        clientRateConfig.setAction(0);
        clientRateConfig.setClientRateLimit(list);
        return clientRateConfig;
    }

    private void a(Client client, Client client2) {
        this.l.debug("updateInformClientsToDb client: {}, site: {}", (Object)client2.getName(), (Object)client2.getSite());
        Ap ap = this.g.getApByMac(client2.getApMac());
        if (ap == null) {
            this.l.debug("ap {} not exist, maybe already forgot", (Object)client2.getApMac());
            if (client != null && client.isActive()) {
                client.setActive(false);
                this.a.save(client);
                this.f.deleteCurrentClientStat(client.getMac());
            }
            return;
        }
        if (client == null) {
            client = new Client();
            client.setMac(client2.getMac());
            client.setFirstSeen(client2.getLastSeen());
            client.setIp("");
            client.setName(client2.getName());
        }
        client.setSite(client2.getSite());
        client.setCcq(client2.getCcq());
        client.setDownload(client2.getDownload());
        client.setUpload(client2.getUpload());
        client.setDuration(client2.getDuration());
        client.setGuest(client2.isGuest());
        client.setLastSeen(client2.getLastSeen());
        client.setRate(client2.getRate());
        client.setSnr(client2.getSnr());
        client.setRssi(client2.getRssi());
        client.setSsid(client2.getSsid());
        client.setRadioId(client2.getRadioId());
        client.setApMac(client2.getApMac());
        client.setActive(true);
        client.setApName(ap.getName());
        if (!com.tp_link.eap.util.a.e.a((String)client2.getName())) {
            client.setName(client2.getName());
        }
        if (!com.tp_link.eap.util.l.f((String)client2.getIp())) {
            client.setIp(client2.getIp());
            client.setLongIp(client2.getLongIp());
        } else {
            this.l.debug("Ip of client {} is {}, use old ip {}", new Object[]{client2.getName(), client2.getIp(), client.getIp()});
        }
        this.refreshClient(client);
        this.f.refreshCurrentClientStat(client);
    }

    private void a() {
        if (com.tp_link.eap.util.l.b()) {
            return;
        }
        long l2 = this.a.count();
        while (l2 >= 41000L) {
            this.l.debug("client {} reached maximum", (Object)l2);
            List<Client> list = this.a.getAndClearOldest(1000);
            ArrayList<StatLifeClient> arrayList = new ArrayList<StatLifeClient>();
            ArrayList<ClientHistory> arrayList2 = new ArrayList<ClientHistory>();
            ArrayList<Guest> arrayList3 = new ArrayList<Guest>();
            for (Client client : list) {
                arrayList.add(this.b.findByMacAndSite(client.getMac(), client.getSite()));
                arrayList2.addAll(this.c.findByClientMacAndSite(client.getMac(), client.getSite()));
                arrayList3.addAll(this.d.findBySiteAndClientMac(client.getSite(), client.getMac()));
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                this.b.delete(arrayList);
            }
            if (!CollectionUtils.isEmpty(arrayList2)) {
                this.c.delete(arrayList2);
            }
            if (!CollectionUtils.isEmpty(arrayList3)) {
                this.d.delete(arrayList3);
            }
            l2 = this.a.count();
            this.l.debug("after clear num is {}", (Object)l2);
        }
    }
}

